---@meta

---@class FDisplayClusterConfigurationClusterItemReferenceList
---@field ItemNames TArray<FString>
local FDisplayClusterConfigurationClusterItemReferenceList = {}



---@class FDisplayClusterConfigurationClusterSync
---@field RenderSyncPolicy FDisplayClusterConfigurationRenderSyncPolicy
---@field InputSyncPolicy FDisplayClusterConfigurationInputSyncPolicy
local FDisplayClusterConfigurationClusterSync = {}



---@class FDisplayClusterConfigurationDiagnostics
---@field bSimulateLag boolean
---@field MinLagTime float
---@field MaxLagTime float
local FDisplayClusterConfigurationDiagnostics = {}



---@class FDisplayClusterConfigurationExternalImage
---@field ImagePath FString
local FDisplayClusterConfigurationExternalImage = {}



---@class FDisplayClusterConfigurationFailoverSettings
---@field FailoverPolicy EDisplayClusterConfigurationFailoverPolicy
local FDisplayClusterConfigurationFailoverSettings = {}



---@class FDisplayClusterConfigurationFailoverSettings_500
---@field FailoverPolicy EDisplayClusterConfigurationFailoverPolicy
local FDisplayClusterConfigurationFailoverSettings_500 = {}



---@class FDisplayClusterConfigurationFramePostProcess_OutputRemap
---@field bEnable boolean
---@field DataSource EDisplayClusterConfigurationFramePostProcess_OutputRemapSource
---@field StaticMesh UStaticMesh
---@field MeshComponentName FString
---@field ExternalFile FString
local FDisplayClusterConfigurationFramePostProcess_OutputRemap = {}



---@class FDisplayClusterConfigurationFramePostProcess_OutputRemap_427
---@field bEnable boolean
---@field DataSource FString
---@field StaticMeshAsset FString
---@field ExternalFile FString
local FDisplayClusterConfigurationFramePostProcess_OutputRemap_427 = {}



---@class FDisplayClusterConfigurationFramePostProcess_OutputRemap_500
---@field bEnable boolean
---@field DataSource FString
---@field StaticMeshAsset FString
---@field ExternalFile FString
local FDisplayClusterConfigurationFramePostProcess_OutputRemap_500 = {}



---@class FDisplayClusterConfigurationGlobalMediaSettings
---@field Latency int32
local FDisplayClusterConfigurationGlobalMediaSettings = {}



---@class FDisplayClusterConfigurationICVFX_CameraAdvancedRenderSettings
---@field RenderTargetRatio float
---@field GPUIndex int32
---@field StereoGPUIndex int32
---@field StereoMode EDisplayClusterConfigurationViewport_StereoMode
---@field RenderFamilyGroup int32
local FDisplayClusterConfigurationICVFX_CameraAdvancedRenderSettings = {}



---@class FDisplayClusterConfigurationICVFX_CameraBorder
---@field Enable boolean
---@field Thickness float
---@field Color FLinearColor
local FDisplayClusterConfigurationICVFX_CameraBorder = {}



---@class FDisplayClusterConfigurationICVFX_CameraCustomFrustum
---@field EstimatedOverscanResolution FIntPoint
---@field InnerFrustumResolution FIntPoint
---@field OverscanPixelsIncrease float
---@field bEnable boolean
---@field bAdaptResolution boolean
---@field FieldOfViewMultiplier float
---@field Mode EDisplayClusterConfigurationViewportCustomFrustumMode
---@field Left float
---@field Right float
---@field Top float
---@field Bottom float
local FDisplayClusterConfigurationICVFX_CameraCustomFrustum = {}



---@class FDisplayClusterConfigurationICVFX_CameraDepthOfField
---@field bEnableDepthOfFieldCompensation boolean
---@field bAutomaticallySetDistanceToWall boolean
---@field DistanceToWall float
---@field DistanceToWallOffset float
---@field DepthOfFieldGain float
---@field CompensationLUT TSoftObjectPtr<UTexture2D>
---@field DynamicCompensationLUT UTexture2D
local FDisplayClusterConfigurationICVFX_CameraDepthOfField = {}



---@class FDisplayClusterConfigurationICVFX_CameraMotionBlur
---@field MotionBlurMode EDisplayClusterConfigurationCameraMotionBlurMode
---@field TranslationScale float
---@field MotionBlurPPS FDisplayClusterConfigurationICVFX_CameraMotionBlurOverridePPS
local FDisplayClusterConfigurationICVFX_CameraMotionBlur = {}



---@class FDisplayClusterConfigurationICVFX_CameraMotionBlurOverridePPS
---@field bReplaceEnable boolean
---@field MotionBlurAmount float
---@field MotionBlurMax float
---@field MotionBlurPerObjectSize float
local FDisplayClusterConfigurationICVFX_CameraMotionBlurOverridePPS = {}



---@class FDisplayClusterConfigurationICVFX_CameraOCIO
---@field AllNodesOCIOConfiguration FDisplayClusterConfigurationOCIOConfiguration
---@field PerNodeOCIOProfiles TArray<FDisplayClusterConfigurationOCIOProfile>
local FDisplayClusterConfigurationICVFX_CameraOCIO = {}



---@class FDisplayClusterConfigurationICVFX_CameraRenderSettings
---@field CustomFrameSize FDisplayClusterConfigurationICVFX_CustomSize
---@field RenderOrder int32
---@field CustomPostprocess FDisplayClusterConfigurationViewport_CustomPostprocess
---@field bUseCameraComponentPostprocess boolean
---@field Replace FDisplayClusterConfigurationPostRender_Override
---@field Media FDisplayClusterConfigurationMediaICVFX
---@field PostprocessBlur FDisplayClusterConfigurationPostRender_BlurPostprocess
---@field GenerateMips FDisplayClusterConfigurationPostRender_GenerateMips
---@field AdvancedRenderSettings FDisplayClusterConfigurationICVFX_CameraAdvancedRenderSettings
local FDisplayClusterConfigurationICVFX_CameraRenderSettings = {}



---@class FDisplayClusterConfigurationICVFX_CameraSettings
---@field bEnable boolean
---@field ExternalCameraActor TSoftObjectPtr<ACineCameraActor>
---@field BufferRatio float
---@field CustomFrustum FDisplayClusterConfigurationICVFX_CameraCustomFrustum
---@field SoftEdge FDisplayClusterConfigurationICVFX_CameraSoftEdge
---@field FrustumRotation FRotator
---@field FrustumOffset FVector
---@field OffCenterProjectionOffset FVector2D
---@field Border FDisplayClusterConfigurationICVFX_CameraBorder
---@field CameraMotionBlur FDisplayClusterConfigurationICVFX_CameraMotionBlur
---@field CameraDepthOfField FDisplayClusterConfigurationICVFX_CameraDepthOfField
---@field RenderSettings FDisplayClusterConfigurationICVFX_CameraRenderSettings
---@field Chromakey FDisplayClusterConfigurationICVFX_ChromakeySettings
---@field CameraOCIO FDisplayClusterConfigurationICVFX_CameraOCIO
---@field EnableInnerFrustumColorGrading boolean
---@field AllNodesColorGrading FDisplayClusterConfigurationViewport_AllNodesColorGrading
---@field PerNodeColorGrading TArray<FDisplayClusterConfigurationViewport_PerNodeColorGrading>
---@field CameraHideList FDisplayClusterConfigurationICVFX_VisibilityList
---@field HiddenICVFXViewports FDisplayClusterConfigurationClusterItemReferenceList
local FDisplayClusterConfigurationICVFX_CameraSettings = {}



---@class FDisplayClusterConfigurationICVFX_CameraSoftEdge
---@field Vertical float
---@field Horizontal float
---@field Feather float
local FDisplayClusterConfigurationICVFX_CameraSoftEdge = {}



---@class FDisplayClusterConfigurationICVFX_ChromakeyMarkers
---@field bEnable boolean
---@field MarkerColor FLinearColor
---@field MarkerTileRGBA UTexture
---@field MarkerSizeScale float
---@field MarkerTileDistance float
---@field MarkerTileOffset FVector2D
local FDisplayClusterConfigurationICVFX_ChromakeyMarkers = {}



---@class FDisplayClusterConfigurationICVFX_ChromakeyRenderSettings
---@field bEnable boolean
---@field bReplaceCameraViewport boolean
---@field CustomSize FDisplayClusterConfigurationICVFX_CustomSize
---@field ShowOnlyList FDisplayClusterConfigurationICVFX_VisibilityList
---@field Replace FDisplayClusterConfigurationPostRender_Override
---@field PostprocessBlur FDisplayClusterConfigurationPostRender_BlurPostprocess
---@field GenerateMips FDisplayClusterConfigurationPostRender_GenerateMips
---@field AdvancedRenderSettings FDisplayClusterConfigurationICVFX_OverlayAdvancedRenderSettings
local FDisplayClusterConfigurationICVFX_ChromakeyRenderSettings = {}



---@class FDisplayClusterConfigurationICVFX_ChromakeySettings
---@field bEnable boolean
---@field ChromakeyType EDisplayClusterConfigurationICVFX_ChromakeyType
---@field ChromakeySettingsSource EDisplayClusterConfigurationICVFX_ChromakeySettingsSource
---@field ChromakeyColor FLinearColor
---@field ChromakeyRenderTexture FDisplayClusterConfigurationICVFX_ChromakeyRenderSettings
---@field ChromakeyMarkers FDisplayClusterConfigurationICVFX_ChromakeyMarkers
local FDisplayClusterConfigurationICVFX_ChromakeySettings = {}



---@class FDisplayClusterConfigurationICVFX_CustomSize
---@field bUseCustomSize boolean
---@field CustomWidth int32
---@field CustomHeight int32
local FDisplayClusterConfigurationICVFX_CustomSize = {}



---@class FDisplayClusterConfigurationICVFX_GlobalChromakeySettings
---@field ChromakeyColor FLinearColor
---@field ChromakeyMarkers FDisplayClusterConfigurationICVFX_ChromakeyMarkers
local FDisplayClusterConfigurationICVFX_GlobalChromakeySettings = {}



---@class FDisplayClusterConfigurationICVFX_LightcardCustomOCIO
---@field AllViewportsOCIOConfiguration FDisplayClusterConfigurationOCIOConfiguration
---@field PerViewportOCIOProfiles TArray<FDisplayClusterConfigurationOCIOProfile>
local FDisplayClusterConfigurationICVFX_LightcardCustomOCIO = {}



---@class FDisplayClusterConfigurationICVFX_LightcardOCIO
---@field LightcardOCIOMode EDisplayClusterConfigurationViewportLightcardOCIOMode
---@field CustomOCIO FDisplayClusterConfigurationICVFX_LightcardCustomOCIO
local FDisplayClusterConfigurationICVFX_LightcardOCIO = {}



---@class FDisplayClusterConfigurationICVFX_LightcardRenderSettings
---@field bReplaceViewport boolean
---@field Replace FDisplayClusterConfigurationPostRender_Override
---@field PostprocessBlur FDisplayClusterConfigurationPostRender_BlurPostprocess
---@field GenerateMips FDisplayClusterConfigurationPostRender_GenerateMips
---@field AdvancedRenderSettings FDisplayClusterConfigurationICVFX_OverlayAdvancedRenderSettings
local FDisplayClusterConfigurationICVFX_LightcardRenderSettings = {}



---@class FDisplayClusterConfigurationICVFX_LightcardSettings
---@field bEnable boolean
---@field bIgnoreOuterViewportsFreezingForLightcards boolean
---@field Blendingmode EDisplayClusterConfigurationICVFX_LightcardRenderMode
---@field ShowOnlyList FDisplayClusterConfigurationICVFX_VisibilityList
---@field RenderSettings FDisplayClusterConfigurationICVFX_LightcardRenderSettings
---@field LightcardOCIO FDisplayClusterConfigurationICVFX_LightcardOCIO
---@field bEnableOuterViewportColorGrading boolean
local FDisplayClusterConfigurationICVFX_LightcardSettings = {}



---@class FDisplayClusterConfigurationICVFX_OverlayAdvancedRenderSettings
---@field BufferRatio float
---@field RenderTargetRatio float
---@field GPUIndex int32
---@field StereoGPUIndex int32
---@field StereoMode EDisplayClusterConfigurationViewport_StereoMode
---@field RenderFamilyGroup int32
local FDisplayClusterConfigurationICVFX_OverlayAdvancedRenderSettings = {}



---@class FDisplayClusterConfigurationICVFX_Size
---@field Width int32
---@field Height int32
local FDisplayClusterConfigurationICVFX_Size = {}



---@class FDisplayClusterConfigurationICVFX_StageSettings
---@field bEnableInnerFrustums boolean
---@field bEnableInnerFrustumChromakeyOverlap boolean
---@field DefaultFrameSize FDisplayClusterConfigurationICVFX_Size
---@field Lightcard FDisplayClusterConfigurationICVFX_LightcardSettings
---@field bFreezeRenderOuterViewports boolean
---@field HideList FDisplayClusterConfigurationICVFX_VisibilityList
---@field OuterViewportHideList FDisplayClusterConfigurationICVFX_VisibilityList
---@field EnableColorGrading boolean
---@field EntireClusterColorGrading FDisplayClusterConfigurationViewport_EntireClusterColorGrading
---@field PerViewportColorGrading TArray<FDisplayClusterConfigurationViewport_PerViewportColorGrading>
---@field ViewportOCIO FDisplayClusterConfigurationICVFX_ViewportOCIO
---@field GlobalChromakey FDisplayClusterConfigurationICVFX_GlobalChromakeySettings
local FDisplayClusterConfigurationICVFX_StageSettings = {}



---@class FDisplayClusterConfigurationICVFX_ViewportOCIO
---@field AllViewportsOCIOConfiguration FDisplayClusterConfigurationOCIOConfiguration
---@field PerViewportOCIOProfiles TArray<FDisplayClusterConfigurationOCIOProfile>
local FDisplayClusterConfigurationICVFX_ViewportOCIO = {}



---@class FDisplayClusterConfigurationICVFX_VisibilityList
---@field ActorLayers TArray<FActorLayer>
---@field Actors TArray<TSoftObjectPtr<AActor>>
---@field RootActorComponentNames TArray<FString>
local FDisplayClusterConfigurationICVFX_VisibilityList = {}



---@class FDisplayClusterConfigurationInfo
---@field Description FString
---@field Version FString
---@field AssetPath FString
local FDisplayClusterConfigurationInfo = {}



---@class FDisplayClusterConfigurationInputSyncPolicy : FDisplayClusterConfigurationPolymorphicEntity
local FDisplayClusterConfigurationInputSyncPolicy = {}


---@class FDisplayClusterConfigurationJsonClusterNode_426
---@field Host FString
---@field Sound boolean
---@field FullScreen boolean
---@field Window FDisplayClusterConfigurationJsonRectangle_426
---@field PostProcess TMap<FString, FDisplayClusterConfigurationJsonPostprocess_426>
---@field Viewports TMap<FString, FDisplayClusterConfigurationJsonViewport_426>
local FDisplayClusterConfigurationJsonClusterNode_426 = {}



---@class FDisplayClusterConfigurationJsonClusterNode_427
---@field Host FString
---@field Sound boolean
---@field FullScreen boolean
---@field Window FDisplayClusterConfigurationJsonRectangle_427
---@field PostProcess TMap<FString, FDisplayClusterConfigurationJsonPostprocess_427>
---@field Viewports TMap<FString, FDisplayClusterConfigurationJsonViewport_427>
---@field OutputRemap FDisplayClusterConfigurationFramePostProcess_OutputRemap_427
local FDisplayClusterConfigurationJsonClusterNode_427 = {}



---@class FDisplayClusterConfigurationJsonClusterNode_500
---@field Host FString
---@field Sound boolean
---@field FullScreen boolean
---@field RenderHeadless boolean
---@field GraphicsAdapter int32
---@field TextureShare boolean
---@field Window FDisplayClusterConfigurationJsonRectangle_500
---@field PostProcess TMap<FString, FDisplayClusterConfigurationJsonPostprocess_500>
---@field Viewports TMap<FString, FDisplayClusterConfigurationJsonViewport_500>
---@field OutputRemap FDisplayClusterConfigurationFramePostProcess_OutputRemap_500
local FDisplayClusterConfigurationJsonClusterNode_500 = {}



---@class FDisplayClusterConfigurationJsonClusterSyncPolicy_426 : FDisplayClusterConfigurationJsonPolymorphicEntity_426
local FDisplayClusterConfigurationJsonClusterSyncPolicy_426 = {}


---@class FDisplayClusterConfigurationJsonClusterSyncPolicy_427 : FDisplayClusterConfigurationJsonPolymorphicEntity_427
local FDisplayClusterConfigurationJsonClusterSyncPolicy_427 = {}


---@class FDisplayClusterConfigurationJsonClusterSyncPolicy_500 : FDisplayClusterConfigurationJsonPolymorphicEntity_500
local FDisplayClusterConfigurationJsonClusterSyncPolicy_500 = {}


---@class FDisplayClusterConfigurationJsonClusterSync_426
---@field RenderSyncPolicy FDisplayClusterConfigurationJsonClusterSyncPolicy_426
---@field InputSyncPolicy FDisplayClusterConfigurationJsonClusterSyncPolicy_426
local FDisplayClusterConfigurationJsonClusterSync_426 = {}



---@class FDisplayClusterConfigurationJsonClusterSync_427
---@field RenderSyncPolicy FDisplayClusterConfigurationJsonClusterSyncPolicy_427
---@field InputSyncPolicy FDisplayClusterConfigurationJsonClusterSyncPolicy_427
local FDisplayClusterConfigurationJsonClusterSync_427 = {}



---@class FDisplayClusterConfigurationJsonClusterSync_500
---@field RenderSyncPolicy FDisplayClusterConfigurationJsonClusterSyncPolicy_500
---@field InputSyncPolicy FDisplayClusterConfigurationJsonClusterSyncPolicy_500
local FDisplayClusterConfigurationJsonClusterSync_500 = {}



---@class FDisplayClusterConfigurationJsonCluster_426
---@field MasterNode FDisplayClusterConfigurationJsonPrimaryNode_426
---@field Sync FDisplayClusterConfigurationJsonClusterSync_426
---@field Network TMap<FString, FString>
---@field Nodes TMap<FString, FDisplayClusterConfigurationJsonClusterNode_426>
local FDisplayClusterConfigurationJsonCluster_426 = {}



---@class FDisplayClusterConfigurationJsonCluster_427
---@field MasterNode FDisplayClusterConfigurationJsonPrimaryNode_427
---@field Sync FDisplayClusterConfigurationJsonClusterSync_427
---@field Network TMap<FString, FString>
---@field Nodes TMap<FString, FDisplayClusterConfigurationJsonClusterNode_427>
local FDisplayClusterConfigurationJsonCluster_427 = {}



---@class FDisplayClusterConfigurationJsonCluster_500
---@field PrimaryNode FDisplayClusterConfigurationJsonPrimaryNode_500
---@field Sync FDisplayClusterConfigurationJsonClusterSync_500
---@field Network TMap<FString, FString>
---@field Failover FDisplayClusterConfigurationFailoverSettings_500
---@field Nodes TMap<FString, FDisplayClusterConfigurationJsonClusterNode_500>
local FDisplayClusterConfigurationJsonCluster_500 = {}



---@class FDisplayClusterConfigurationJsonContainer_426
---@field nDisplay FDisplayClusterConfigurationJsonNdisplay_426
local FDisplayClusterConfigurationJsonContainer_426 = {}



---@class FDisplayClusterConfigurationJsonContainer_427
---@field nDisplay FDisplayClusterConfigurationJsonNdisplay_427
local FDisplayClusterConfigurationJsonContainer_427 = {}



---@class FDisplayClusterConfigurationJsonContainer_500
---@field nDisplay FDisplayClusterConfigurationJsonNdisplay_500
local FDisplayClusterConfigurationJsonContainer_500 = {}



---@class FDisplayClusterConfigurationJsonDiagnostics_426
---@field SimulateLag boolean
---@field MinLagTime float
---@field MaxLagTime float
local FDisplayClusterConfigurationJsonDiagnostics_426 = {}



---@class FDisplayClusterConfigurationJsonDiagnostics_427
---@field SimulateLag boolean
---@field MinLagTime float
---@field MaxLagTime float
local FDisplayClusterConfigurationJsonDiagnostics_427 = {}



---@class FDisplayClusterConfigurationJsonDiagnostics_500
---@field SimulateLag boolean
---@field MinLagTime float
---@field MaxLagTime float
local FDisplayClusterConfigurationJsonDiagnostics_500 = {}



---@class FDisplayClusterConfigurationJsonMisc_427
---@field bFollowLocalPlayerCamera boolean
---@field bExitOnEsc boolean
local FDisplayClusterConfigurationJsonMisc_427 = {}



---@class FDisplayClusterConfigurationJsonMisc_500
---@field bFollowLocalPlayerCamera boolean
---@field bExitOnEsc boolean
---@field bOverrideViewportsFromExternalConfig boolean
---@field bOverrideTransformsFromExternalConfig boolean
local FDisplayClusterConfigurationJsonMisc_500 = {}



---@class FDisplayClusterConfigurationJsonNdisplay_426
---@field Description FString
---@field Version FString
---@field AssetPath FString
---@field Scene FDisplayClusterConfigurationJsonScene_426
---@field Cluster FDisplayClusterConfigurationJsonCluster_426
---@field CustomParameters TMap<FString, FString>
---@field Diagnostics FDisplayClusterConfigurationJsonDiagnostics_426
local FDisplayClusterConfigurationJsonNdisplay_426 = {}



---@class FDisplayClusterConfigurationJsonNdisplay_427
---@field Description FString
---@field Version FString
---@field AssetPath FString
---@field Misc FDisplayClusterConfigurationJsonMisc_427
---@field Scene FDisplayClusterConfigurationJsonScene_427
---@field Cluster FDisplayClusterConfigurationJsonCluster_427
---@field CustomParameters TMap<FString, FString>
---@field Diagnostics FDisplayClusterConfigurationJsonDiagnostics_427
local FDisplayClusterConfigurationJsonNdisplay_427 = {}



---@class FDisplayClusterConfigurationJsonNdisplay_500
---@field Description FString
---@field Version FString
---@field AssetPath FString
---@field Misc FDisplayClusterConfigurationJsonMisc_500
---@field Scene FDisplayClusterConfigurationJsonScene_500
---@field Cluster FDisplayClusterConfigurationJsonCluster_500
---@field CustomParameters TMap<FString, FString>
---@field Diagnostics FDisplayClusterConfigurationJsonDiagnostics_500
local FDisplayClusterConfigurationJsonNdisplay_500 = {}



---@class FDisplayClusterConfigurationJsonOverscan_427
---@field bEnabled boolean
---@field Mode FString
---@field Left int32
---@field Right int32
---@field Top int32
---@field Bottom int32
---@field Oversize boolean
local FDisplayClusterConfigurationJsonOverscan_427 = {}



---@class FDisplayClusterConfigurationJsonOverscan_500
---@field bEnabled boolean
---@field Mode FString
---@field Left int32
---@field Right int32
---@field Top int32
---@field Bottom int32
---@field Oversize boolean
local FDisplayClusterConfigurationJsonOverscan_500 = {}



---@class FDisplayClusterConfigurationJsonPolymorphicEntity_426
---@field Type FString
---@field Parameters TMap<FString, FString>
local FDisplayClusterConfigurationJsonPolymorphicEntity_426 = {}



---@class FDisplayClusterConfigurationJsonPolymorphicEntity_427
---@field Type FString
---@field Parameters TMap<FString, FString>
local FDisplayClusterConfigurationJsonPolymorphicEntity_427 = {}



---@class FDisplayClusterConfigurationJsonPolymorphicEntity_500
---@field Type FString
---@field Parameters TMap<FString, FString>
local FDisplayClusterConfigurationJsonPolymorphicEntity_500 = {}



---@class FDisplayClusterConfigurationJsonPostprocess_426 : FDisplayClusterConfigurationJsonPolymorphicEntity_426
local FDisplayClusterConfigurationJsonPostprocess_426 = {}


---@class FDisplayClusterConfigurationJsonPostprocess_427 : FDisplayClusterConfigurationJsonPolymorphicEntity_427
local FDisplayClusterConfigurationJsonPostprocess_427 = {}


---@class FDisplayClusterConfigurationJsonPostprocess_500 : FDisplayClusterConfigurationJsonPolymorphicEntity_500
local FDisplayClusterConfigurationJsonPostprocess_500 = {}


---@class FDisplayClusterConfigurationJsonPrimaryNode_426
---@field ID FString
---@field Ports TMap<FString, uint16>
local FDisplayClusterConfigurationJsonPrimaryNode_426 = {}



---@class FDisplayClusterConfigurationJsonPrimaryNode_427
---@field ID FString
---@field Ports TMap<FString, uint16>
local FDisplayClusterConfigurationJsonPrimaryNode_427 = {}



---@class FDisplayClusterConfigurationJsonPrimaryNode_500
---@field ID FString
---@field Ports TMap<FString, uint16>
local FDisplayClusterConfigurationJsonPrimaryNode_500 = {}



---@class FDisplayClusterConfigurationJsonProjectionPolicy_426 : FDisplayClusterConfigurationJsonPolymorphicEntity_426
local FDisplayClusterConfigurationJsonProjectionPolicy_426 = {}


---@class FDisplayClusterConfigurationJsonProjectionPolicy_427 : FDisplayClusterConfigurationJsonPolymorphicEntity_427
local FDisplayClusterConfigurationJsonProjectionPolicy_427 = {}


---@class FDisplayClusterConfigurationJsonProjectionPolicy_500 : FDisplayClusterConfigurationJsonPolymorphicEntity_500
local FDisplayClusterConfigurationJsonProjectionPolicy_500 = {}


---@class FDisplayClusterConfigurationJsonRectangle_426
---@field X int32
---@field Y int32
---@field W int32
---@field H int32
local FDisplayClusterConfigurationJsonRectangle_426 = {}



---@class FDisplayClusterConfigurationJsonRectangle_427
---@field X int32
---@field Y int32
---@field W int32
---@field H int32
local FDisplayClusterConfigurationJsonRectangle_427 = {}



---@class FDisplayClusterConfigurationJsonRectangle_500
---@field X int32
---@field Y int32
---@field W int32
---@field H int32
local FDisplayClusterConfigurationJsonRectangle_500 = {}



---@class FDisplayClusterConfigurationJsonRotator_426
---@field Pitch float
---@field Yaw float
---@field Roll float
local FDisplayClusterConfigurationJsonRotator_426 = {}



---@class FDisplayClusterConfigurationJsonRotator_427
---@field Pitch float
---@field Yaw float
---@field Roll float
local FDisplayClusterConfigurationJsonRotator_427 = {}



---@class FDisplayClusterConfigurationJsonRotator_500
---@field Pitch float
---@field Yaw float
---@field Roll float
local FDisplayClusterConfigurationJsonRotator_500 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentCamera_426 : FDisplayClusterConfigurationJsonSceneComponentXform_426
---@field InterpupillaryDistance float
---@field SwapEyes boolean
---@field StereoOffset FString
local FDisplayClusterConfigurationJsonSceneComponentCamera_426 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentCamera_427 : FDisplayClusterConfigurationJsonSceneComponentXform_427
---@field InterpupillaryDistance float
---@field SwapEyes boolean
---@field StereoOffset FString
local FDisplayClusterConfigurationJsonSceneComponentCamera_427 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentCamera_500 : FDisplayClusterConfigurationJsonSceneComponentXform_500
---@field InterpupillaryDistance float
---@field SwapEyes boolean
---@field StereoOffset FString
local FDisplayClusterConfigurationJsonSceneComponentCamera_500 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentScreen_426 : FDisplayClusterConfigurationJsonSceneComponentXform_426
---@field Size FDisplayClusterConfigurationJsonSizeFloat_426
local FDisplayClusterConfigurationJsonSceneComponentScreen_426 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentScreen_427 : FDisplayClusterConfigurationJsonSceneComponentXform_427
---@field Size FDisplayClusterConfigurationJsonSizeFloat_427
local FDisplayClusterConfigurationJsonSceneComponentScreen_427 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentScreen_500 : FDisplayClusterConfigurationJsonSceneComponentXform_500
---@field Size FDisplayClusterConfigurationJsonSizeFloat_500
local FDisplayClusterConfigurationJsonSceneComponentScreen_500 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentXform_426 : FDisplayClusterConfigurationJsonSceneComponent_426
---@field Parent FString
---@field Location FDisplayClusterConfigurationJsonVector_426
---@field Rotation FDisplayClusterConfigurationJsonRotator_426
local FDisplayClusterConfigurationJsonSceneComponentXform_426 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentXform_427 : FDisplayClusterConfigurationJsonSceneComponent_427
---@field ParentID FString
---@field Location FDisplayClusterConfigurationJsonVector_427
---@field Rotation FDisplayClusterConfigurationJsonRotator_427
local FDisplayClusterConfigurationJsonSceneComponentXform_427 = {}



---@class FDisplayClusterConfigurationJsonSceneComponentXform_500 : FDisplayClusterConfigurationJsonSceneComponent_500
---@field ParentID FString
---@field Location FDisplayClusterConfigurationJsonVector_500
---@field Rotation FDisplayClusterConfigurationJsonRotator_500
local FDisplayClusterConfigurationJsonSceneComponentXform_500 = {}



---@class FDisplayClusterConfigurationJsonSceneComponent_426
local FDisplayClusterConfigurationJsonSceneComponent_426 = {}


---@class FDisplayClusterConfigurationJsonSceneComponent_427
local FDisplayClusterConfigurationJsonSceneComponent_427 = {}


---@class FDisplayClusterConfigurationJsonSceneComponent_500
local FDisplayClusterConfigurationJsonSceneComponent_500 = {}


---@class FDisplayClusterConfigurationJsonScene_426
---@field Xforms TMap<FString, FDisplayClusterConfigurationJsonSceneComponentXform_426>
---@field Cameras TMap<FString, FDisplayClusterConfigurationJsonSceneComponentCamera_426>
---@field Screens TMap<FString, FDisplayClusterConfigurationJsonSceneComponentScreen_426>
local FDisplayClusterConfigurationJsonScene_426 = {}



---@class FDisplayClusterConfigurationJsonScene_427
---@field Xforms TMap<FString, FDisplayClusterConfigurationJsonSceneComponentXform_427>
---@field Cameras TMap<FString, FDisplayClusterConfigurationJsonSceneComponentCamera_427>
---@field Screens TMap<FString, FDisplayClusterConfigurationJsonSceneComponentScreen_427>
local FDisplayClusterConfigurationJsonScene_427 = {}



---@class FDisplayClusterConfigurationJsonScene_500
---@field Xforms TMap<FString, FDisplayClusterConfigurationJsonSceneComponentXform_500>
---@field Cameras TMap<FString, FDisplayClusterConfigurationJsonSceneComponentCamera_500>
---@field Screens TMap<FString, FDisplayClusterConfigurationJsonSceneComponentScreen_500>
local FDisplayClusterConfigurationJsonScene_500 = {}



---@class FDisplayClusterConfigurationJsonSizeFloat_426
---@field Width float
---@field Height float
local FDisplayClusterConfigurationJsonSizeFloat_426 = {}



---@class FDisplayClusterConfigurationJsonSizeFloat_427
---@field Width float
---@field Height float
local FDisplayClusterConfigurationJsonSizeFloat_427 = {}



---@class FDisplayClusterConfigurationJsonSizeFloat_500
---@field Width float
---@field Height float
local FDisplayClusterConfigurationJsonSizeFloat_500 = {}



---@class FDisplayClusterConfigurationJsonSizeInt_426
---@field Width int32
---@field Height int32
local FDisplayClusterConfigurationJsonSizeInt_426 = {}



---@class FDisplayClusterConfigurationJsonSizeInt_427
---@field Width int32
---@field Height int32
local FDisplayClusterConfigurationJsonSizeInt_427 = {}



---@class FDisplayClusterConfigurationJsonSizeInt_500
---@field Width int32
---@field Height int32
local FDisplayClusterConfigurationJsonSizeInt_500 = {}



---@class FDisplayClusterConfigurationJsonVector_426
---@field X float
---@field Y float
---@field Z float
local FDisplayClusterConfigurationJsonVector_426 = {}



---@class FDisplayClusterConfigurationJsonVector_427
---@field X float
---@field Y float
---@field Z float
local FDisplayClusterConfigurationJsonVector_427 = {}



---@class FDisplayClusterConfigurationJsonVector_500
---@field X float
---@field Y float
---@field Z float
local FDisplayClusterConfigurationJsonVector_500 = {}



---@class FDisplayClusterConfigurationJsonViewport_426
---@field Camera FString
---@field BufferRatio float
---@field GPUIndex int32
---@field AllowCrossGPUTransfer boolean
---@field IsShared boolean
---@field Region FDisplayClusterConfigurationJsonRectangle_426
---@field ProjectionPolicy FDisplayClusterConfigurationJsonProjectionPolicy_426
local FDisplayClusterConfigurationJsonViewport_426 = {}



---@class FDisplayClusterConfigurationJsonViewport_427
---@field Camera FString
---@field BufferRatio float
---@field GPUIndex int32
---@field AllowCrossGPUTransfer boolean
---@field IsShared boolean
---@field Overscan FDisplayClusterConfigurationJsonOverscan_427
---@field Region FDisplayClusterConfigurationJsonRectangle_427
---@field ProjectionPolicy FDisplayClusterConfigurationJsonProjectionPolicy_427
local FDisplayClusterConfigurationJsonViewport_427 = {}



---@class FDisplayClusterConfigurationJsonViewport_500
---@field Camera FString
---@field BufferRatio float
---@field GPUIndex int32
---@field AllowCrossGPUTransfer boolean
---@field IsShared boolean
---@field Overscan FDisplayClusterConfigurationJsonOverscan_500
---@field Region FDisplayClusterConfigurationJsonRectangle_500
---@field ProjectionPolicy FDisplayClusterConfigurationJsonProjectionPolicy_500
local FDisplayClusterConfigurationJsonViewport_500 = {}



---@class FDisplayClusterConfigurationMediaICVFX
---@field bEnable boolean
---@field SplitType EDisplayClusterConfigurationMediaSplitType
---@field MediaInputGroups TArray<FDisplayClusterConfigurationMediaInputGroup>
---@field MediaOutputGroups TArray<FDisplayClusterConfigurationMediaOutputGroup>
---@field TiledSplitLayout FIntPoint
---@field TileOverscan FDisplayClusterConfigurationTile_Overscan
---@field ClusterNodesToRenderUnboundTiles FDisplayClusterConfigurationClusterItemReferenceList
---@field TiledMediaInputGroups TArray<FDisplayClusterConfigurationMediaTiledInputGroup>
---@field TiledMediaOutputGroups TArray<FDisplayClusterConfigurationMediaTiledOutputGroup>
---@field bLateOCIOPass boolean
local FDisplayClusterConfigurationMediaICVFX = {}



---@class FDisplayClusterConfigurationMediaInput
---@field MediaSource UMediaSource
local FDisplayClusterConfigurationMediaInput = {}



---@class FDisplayClusterConfigurationMediaInputGroup : FDisplayClusterConfigurationMediaInput
---@field ClusterNodes FDisplayClusterConfigurationClusterItemReferenceList
local FDisplayClusterConfigurationMediaInputGroup = {}



---@class FDisplayClusterConfigurationMediaNodeBackbuffer
---@field bEnable boolean
---@field MediaOutputs TArray<FDisplayClusterConfigurationMediaOutput>
local FDisplayClusterConfigurationMediaNodeBackbuffer = {}



---@class FDisplayClusterConfigurationMediaOutput
---@field MediaOutput UMediaOutput
---@field OutputSyncPolicy UDisplayClusterMediaOutputSynchronizationPolicy
local FDisplayClusterConfigurationMediaOutput = {}



---@class FDisplayClusterConfigurationMediaOutputGroup : FDisplayClusterConfigurationMediaOutput
---@field ClusterNodes FDisplayClusterConfigurationClusterItemReferenceList
local FDisplayClusterConfigurationMediaOutputGroup = {}



---@class FDisplayClusterConfigurationMediaTiledInputGroup
---@field ClusterNodes FDisplayClusterConfigurationClusterItemReferenceList
---@field Tiles TArray<FDisplayClusterConfigurationMediaUniformTileInput>
local FDisplayClusterConfigurationMediaTiledInputGroup = {}



---@class FDisplayClusterConfigurationMediaTiledOutputGroup
---@field ClusterNodes FDisplayClusterConfigurationClusterItemReferenceList
---@field Tiles TArray<FDisplayClusterConfigurationMediaUniformTileOutput>
---@field OutputSyncPolicy UDisplayClusterMediaOutputSynchronizationPolicy
local FDisplayClusterConfigurationMediaTiledOutputGroup = {}



---@class FDisplayClusterConfigurationMediaUniformTileInput
---@field Position FIntPoint
---@field MediaSource UMediaSource
local FDisplayClusterConfigurationMediaUniformTileInput = {}



---@class FDisplayClusterConfigurationMediaUniformTileOutput
---@field Position FIntPoint
---@field MediaOutput UMediaOutput
local FDisplayClusterConfigurationMediaUniformTileOutput = {}



---@class FDisplayClusterConfigurationMediaViewport
---@field bEnable boolean
---@field MediaInput FDisplayClusterConfigurationMediaInput
---@field MediaOutputs TArray<FDisplayClusterConfigurationMediaOutput>
local FDisplayClusterConfigurationMediaViewport = {}



---@class FDisplayClusterConfigurationNetworkSettings
---@field ConnectRetriesAmount int32
---@field ConnectRetryDelay int32
---@field GameStartBarrierTimeout int32
---@field FrameStartBarrierTimeout int32
---@field FrameEndBarrierTimeout int32
---@field RenderSyncBarrierTimeout int32
local FDisplayClusterConfigurationNetworkSettings = {}



---@class FDisplayClusterConfigurationOCIOConfiguration
---@field bIsEnabled boolean
---@field OCIOConfiguration FOpenColorIODisplayConfiguration
---@field ColorConfiguration FOpenColorIOColorConversionSettings
local FDisplayClusterConfigurationOCIOConfiguration = {}



---@class FDisplayClusterConfigurationOCIOProfile
---@field bIsEnabled boolean
---@field OCIOConfiguration FOpenColorIODisplayConfiguration
---@field ApplyOCIOToObjects TArray<FString>
---@field ColorConfiguration FOpenColorIOColorConversionSettings
local FDisplayClusterConfigurationOCIOProfile = {}



---@class FDisplayClusterConfigurationPolymorphicEntity
---@field Type FString
---@field Parameters TMap<FString, FString>
local FDisplayClusterConfigurationPolymorphicEntity = {}



---@class FDisplayClusterConfigurationPostRender_BlurPostprocess
---@field Mode EDisplayClusterConfiguration_PostRenderBlur
---@field KernelRadius int32
---@field KernelScale float
local FDisplayClusterConfigurationPostRender_BlurPostprocess = {}



---@class FDisplayClusterConfigurationPostRender_GenerateMips
---@field bAutoGenerateMips boolean
---@field MipsSamplerFilter TextureFilter
---@field MipsAddressU TextureAddress
---@field MipsAddressV TextureAddress
---@field bEnabledMaxNumMips boolean
---@field MaxNumMips int32
local FDisplayClusterConfigurationPostRender_GenerateMips = {}



---@class FDisplayClusterConfigurationPostRender_Override
---@field bAllowReplace boolean
---@field SourceTexture UTexture
---@field bShouldUseTextureRegion boolean
---@field TextureRegion FDisplayClusterReplaceTextureCropRectangle
local FDisplayClusterConfigurationPostRender_Override = {}



---@class FDisplayClusterConfigurationPostprocess : FDisplayClusterConfigurationPolymorphicEntity
---@field Order int32
local FDisplayClusterConfigurationPostprocess = {}



---@class FDisplayClusterConfigurationPrimaryNode
---@field ID FString
---@field Ports FDisplayClusterConfigurationPrimaryNodePorts
local FDisplayClusterConfigurationPrimaryNode = {}



---@class FDisplayClusterConfigurationPrimaryNodePorts
---@field ClusterSync uint16
---@field ClusterEventsJson uint16
---@field ClusterEventsBinary uint16
local FDisplayClusterConfigurationPrimaryNodePorts = {}



---@class FDisplayClusterConfigurationProjection : FDisplayClusterConfigurationPolymorphicEntity
local FDisplayClusterConfigurationProjection = {}


---@class FDisplayClusterConfigurationRectangle
---@field X int32
---@field Y int32
---@field W int32
---@field H int32
local FDisplayClusterConfigurationRectangle = {}



---@class FDisplayClusterConfigurationRenderFrame
---@field bAllowRenderTargetAtlasing boolean
---@field ViewFamilyMode EDisplayClusterConfigurationRenderFamilyMode
---@field bShouldUseParentViewportRenderFamily boolean
---@field ClusterRenderTargetRatioMult float
---@field ClusterICVFXInnerViewportRenderTargetRatioMult float
---@field ClusterICVFXOuterViewportRenderTargetRatioMult float
---@field ClusterBufferRatioMult float
---@field ClusterICVFXInnerFrustumBufferRatioMult float
---@field ClusterICVFXOuterViewportBufferRatioMult float
---@field bAllowWarpBlend boolean
local FDisplayClusterConfigurationRenderFrame = {}



---@class FDisplayClusterConfigurationRenderSyncPolicy : FDisplayClusterConfigurationPolymorphicEntity
local FDisplayClusterConfigurationRenderSyncPolicy = {}


---@class FDisplayClusterConfigurationTile_Overscan
---@field bEnabled boolean
---@field bOversize boolean
---@field bOptimizeTileOverscan boolean
---@field Mode EDisplayClusterConfigurationViewportOverscanMode
---@field AllSides float
local FDisplayClusterConfigurationTile_Overscan = {}



---@class FDisplayClusterConfigurationTile_Settings
---@field bEnabled boolean
---@field Layout FIntPoint
local FDisplayClusterConfigurationTile_Settings = {}



---@class FDisplayClusterConfigurationVersion
---@field Version FString
local FDisplayClusterConfigurationVersion = {}



---@class FDisplayClusterConfigurationVersionContainer
---@field nDisplay FDisplayClusterConfigurationVersion
local FDisplayClusterConfigurationVersionContainer = {}



---@class FDisplayClusterConfigurationViewport_AllNodesColorGrading
---@field bEnableInnerFrustumAllNodesColorGrading boolean
---@field bEnableEntireClusterColorGrading boolean
---@field ColorGradingSettings FDisplayClusterConfigurationViewport_ColorGradingRenderingSettings
local FDisplayClusterConfigurationViewport_AllNodesColorGrading = {}



---@class FDisplayClusterConfigurationViewport_ColorGradingMiscSettings
---@field bOverride_BlueCorrection boolean
---@field bOverride_ExpandGamut boolean
---@field bOverride_SceneColorTint boolean
---@field BlueCorrection float
---@field ExpandGamut float
---@field SceneColorTint FLinearColor
local FDisplayClusterConfigurationViewport_ColorGradingMiscSettings = {}



---@class FDisplayClusterConfigurationViewport_ColorGradingRenderingSettings
---@field bOverride_AutoExposureBias boolean
---@field bOverride_ColorCorrectionHighlightsMin boolean
---@field bOverride_ColorCorrectionHighlightsMax boolean
---@field bOverride_ColorCorrectionShadowsMax boolean
---@field BlendWeight float
---@field AutoExposureBias float
---@field WhiteBalance FDisplayClusterConfigurationViewport_ColorGradingWhiteBalanceSettings
---@field Global FDisplayClusterConfigurationViewport_ColorGradingSettings
---@field Shadows FDisplayClusterConfigurationViewport_ColorGradingSettings
---@field ColorCorrectionShadowsMax float
---@field Midtones FDisplayClusterConfigurationViewport_ColorGradingSettings
---@field Highlights FDisplayClusterConfigurationViewport_ColorGradingSettings
---@field ColorCorrectionHighlightsMin float
---@field ColorCorrectionHighlightsMax float
---@field Misc FDisplayClusterConfigurationViewport_ColorGradingMiscSettings
local FDisplayClusterConfigurationViewport_ColorGradingRenderingSettings = {}



---@class FDisplayClusterConfigurationViewport_ColorGradingSettings
---@field bOverride_Saturation boolean
---@field bOverride_Contrast boolean
---@field bOverride_Gamma boolean
---@field bOverride_Gain boolean
---@field bOverride_Offset boolean
---@field Saturation FVector4
---@field Contrast FVector4
---@field Gamma FVector4
---@field Gain FVector4
---@field Offset FVector4
local FDisplayClusterConfigurationViewport_ColorGradingSettings = {}



---@class FDisplayClusterConfigurationViewport_ColorGradingWhiteBalanceSettings
---@field bOverride_TemperatureType boolean
---@field bOverride_WhiteTemp boolean
---@field bOverride_WhiteTint boolean
---@field TemperatureType ETemperatureMethod
---@field WhiteTemp float
---@field WhiteTint float
local FDisplayClusterConfigurationViewport_ColorGradingWhiteBalanceSettings = {}



---@class FDisplayClusterConfigurationViewport_CustomPostprocess
---@field Start FDisplayClusterConfigurationViewport_CustomPostprocessSettings
---@field Override FDisplayClusterConfigurationViewport_CustomPostprocessSettings
---@field Final FDisplayClusterConfigurationViewport_CustomPostprocessSettings
local FDisplayClusterConfigurationViewport_CustomPostprocess = {}



---@class FDisplayClusterConfigurationViewport_CustomPostprocessSettings
---@field bIsEnabled boolean
---@field bIsOneFrame boolean
---@field PostProcessSettings FPostProcessSettings
---@field BlendWeight float
local FDisplayClusterConfigurationViewport_CustomPostprocessSettings = {}



---@class FDisplayClusterConfigurationViewport_EntireClusterColorGrading
---@field bEnableEntireClusterColorGrading boolean
---@field ColorGradingSettings FDisplayClusterConfigurationViewport_ColorGradingRenderingSettings
local FDisplayClusterConfigurationViewport_EntireClusterColorGrading = {}



---@class FDisplayClusterConfigurationViewport_ICVFX
---@field bAllowICVFX boolean
---@field bAllowInnerFrustum boolean
---@field CameraRenderMode EDisplayClusterConfigurationICVFX_OverrideCameraRenderMode
---@field LightcardRenderMode EDisplayClusterConfigurationICVFX_OverrideLightcardRenderMode
local FDisplayClusterConfigurationViewport_ICVFX = {}



---@class FDisplayClusterConfigurationViewport_Overscan
---@field bEnabled boolean
---@field Mode EDisplayClusterConfigurationViewportOverscanMode
---@field Left float
---@field Right float
---@field Top float
---@field Bottom float
---@field bOversize boolean
local FDisplayClusterConfigurationViewport_Overscan = {}



---@class FDisplayClusterConfigurationViewport_PerNodeColorGrading
---@field bIsEnabled boolean
---@field bEntireClusterColorGrading boolean
---@field bAllNodesColorGrading boolean
---@field ColorGradingSettings FDisplayClusterConfigurationViewport_ColorGradingRenderingSettings
---@field ApplyPostProcessToObjects TArray<FString>
local FDisplayClusterConfigurationViewport_PerNodeColorGrading = {}



---@class FDisplayClusterConfigurationViewport_PerViewportColorGrading
---@field bIsEnabled boolean
---@field bIsEntireClusterEnabled boolean
---@field ColorGradingSettings FDisplayClusterConfigurationViewport_ColorGradingRenderingSettings
---@field ApplyPostProcessToObjects TArray<FString>
local FDisplayClusterConfigurationViewport_PerViewportColorGrading = {}



---@class FDisplayClusterConfigurationViewport_Remap
---@field bEnable boolean
---@field BaseRemap FDisplayClusterConfigurationViewport_RemapData
---@field RemapRegions TArray<FDisplayClusterConfigurationViewport_RemapData>
local FDisplayClusterConfigurationViewport_Remap = {}



---@class FDisplayClusterConfigurationViewport_RemapData
---@field ViewportRegion FDisplayClusterConfigurationRectangle
---@field OutputRegion FDisplayClusterConfigurationRectangle
---@field Angle float
---@field bFlipH boolean
---@field bFlipV boolean
local FDisplayClusterConfigurationViewport_RemapData = {}



---@class FDisplayClusterConfigurationViewport_RenderSettings
---@field bEnableCrossGPUTransfer boolean
---@field StereoGPUIndex int32
---@field StereoMode EDisplayClusterConfigurationViewport_StereoMode
---@field BufferRatio float
---@field RenderTargetRatio float
---@field CustomPostprocess FDisplayClusterConfigurationViewport_CustomPostprocess
---@field Replace FDisplayClusterConfigurationPostRender_Override
---@field PostprocessBlur FDisplayClusterConfigurationPostRender_BlurPostprocess
---@field GenerateMips FDisplayClusterConfigurationPostRender_GenerateMips
---@field Overscan FDisplayClusterConfigurationViewport_Overscan
---@field Media FDisplayClusterConfigurationMediaViewport
---@field RenderFamilyGroup int32
local FDisplayClusterConfigurationViewport_RenderSettings = {}



---@class FDisplayClusterEditorPropertyReference
local FDisplayClusterEditorPropertyReference = {}


---@class FDisplayClusterReplaceTextureCropRectangle
---@field Origin FTextureCropOrigin
---@field Size FTextureCropSize
local FDisplayClusterReplaceTextureCropRectangle = {}



---@class FTextureCropOrigin
---@field X int32
---@field Y int32
local FTextureCropOrigin = {}



---@class FTextureCropSize
---@field W int32
---@field H int32
local FTextureCropSize = {}



---@class UDisplayClusterConfigurationCluster : UDisplayClusterConfigurationData_Base
---@field PrimaryNode FDisplayClusterConfigurationPrimaryNode
---@field Sync FDisplayClusterConfigurationClusterSync
---@field Network FDisplayClusterConfigurationNetworkSettings
---@field Failover FDisplayClusterConfigurationFailoverSettings
---@field Nodes TMap<FString, UDisplayClusterConfigurationClusterNode>
local UDisplayClusterConfigurationCluster = {}

---@param OutMeshNames TArray<FString>
function UDisplayClusterConfigurationCluster:GetReferencedMeshNames(OutMeshNames) end
---@param OutNodeIds TArray<FString>
function UDisplayClusterConfigurationCluster:GetNodeIds(OutNodeIds) end
---@param NodeID FString
---@return UDisplayClusterConfigurationClusterNode
function UDisplayClusterConfigurationCluster:GetNode(NodeID) end


---@class UDisplayClusterConfigurationClusterNode : UDisplayClusterConfigurationData_Base
---@field Host FString
---@field bIsSoundEnabled boolean
---@field bIsFullscreen boolean
---@field WindowRect FDisplayClusterConfigurationRectangle
---@field OutputRemap FDisplayClusterConfigurationFramePostProcess_OutputRemap
---@field bRenderHeadless boolean
---@field GraphicsAdapter int32
---@field bEnableTextureShare boolean
---@field Viewports TMap<FString, UDisplayClusterConfigurationViewport>
---@field PostProcess TMap<FString, FDisplayClusterConfigurationPostprocess>
---@field MediaSettings FDisplayClusterConfigurationMediaNodeBackbuffer
local UDisplayClusterConfigurationClusterNode = {}

---@param OutViewportIds TArray<FString>
function UDisplayClusterConfigurationClusterNode:GetViewportIds(OutViewportIds) end
---@param ViewportID FString
---@return UDisplayClusterConfigurationViewport
function UDisplayClusterConfigurationClusterNode:GetViewport(ViewportID) end
---@param OutMeshNames TArray<FString>
function UDisplayClusterConfigurationClusterNode:GetReferencedMeshNames(OutMeshNames) end


---@class UDisplayClusterConfigurationData : UDisplayClusterConfigurationData_Base
---@field Info FDisplayClusterConfigurationInfo
---@field Scene UDisplayClusterConfigurationScene
---@field Cluster UDisplayClusterConfigurationCluster
---@field CustomParameters TMap<FString, FString>
---@field Diagnostics FDisplayClusterConfigurationDiagnostics
---@field RenderFrameSettings FDisplayClusterConfigurationRenderFrame
---@field StageSettings FDisplayClusterConfigurationICVFX_StageSettings
---@field bFollowLocalPlayerCamera boolean
---@field bExitOnEsc boolean
---@field bOverrideViewportsFromExternalConfig boolean
---@field bOverrideTransformsFromExternalConfig boolean
---@field MediaSettings FDisplayClusterConfigurationGlobalMediaSettings
local UDisplayClusterConfigurationData = {}

---@param NodeID FString
---@param PostprocessId FString
---@return boolean
function UDisplayClusterConfigurationData:RemovePostprocess(NodeID, PostprocessId) end
---@param NodeID FString
---@param ViewportID FString
---@return UDisplayClusterConfigurationViewport
function UDisplayClusterConfigurationData:GetViewport(NodeID, ViewportID) end
---@param OutMeshNames TArray<FString>
function UDisplayClusterConfigurationData:GetReferencedMeshNames(OutMeshNames) end
---@param NodeID FString
---@param ViewportID FString
---@param OutProjection FDisplayClusterConfigurationProjection
---@return boolean
function UDisplayClusterConfigurationData:GetProjectionPolicy(NodeID, ViewportID, OutProjection) end
---@param NodeID FString
---@param PostprocessId FString
---@param OutPostprocess FDisplayClusterConfigurationPostprocess
---@return boolean
function UDisplayClusterConfigurationData:GetPostprocess(NodeID, PostprocessId, OutPostprocess) end
---@param NodeID FString
---@param PostprocessId FString
---@param Type FString
---@param Parameters TMap<FString, FString>
---@param Order int32
---@return boolean
function UDisplayClusterConfigurationData:AssignPostprocess(NodeID, PostprocessId, Type, Parameters, Order) end


---@class UDisplayClusterConfigurationData_Base : UObject
---@field ExportedObjects TArray<UObject>
local UDisplayClusterConfigurationData_Base = {}



---@class UDisplayClusterConfigurationHostDisplayData : UObject
---@field HostName FText
---@field Position FVector2D
---@field bAllowManualPlacement boolean
---@field HostResolution FVector2D
---@field bAllowManualSizing boolean
---@field Origin FVector2D
---@field Color FLinearColor
---@field bIsVisible boolean
---@field bIsUnlocked boolean
local UDisplayClusterConfigurationHostDisplayData = {}



---@class UDisplayClusterConfigurationScene : UDisplayClusterConfigurationData_Base
---@field Xforms TMap<FString, UDisplayClusterConfigurationSceneComponentXform>
---@field Screens TMap<FString, UDisplayClusterConfigurationSceneComponentScreen>
---@field Cameras TMap<FString, UDisplayClusterConfigurationSceneComponentCamera>
local UDisplayClusterConfigurationScene = {}



---@class UDisplayClusterConfigurationSceneComponent : UDisplayClusterConfigurationData_Base
---@field ParentID FString
---@field Location FVector
---@field Rotation FRotator
local UDisplayClusterConfigurationSceneComponent = {}



---@class UDisplayClusterConfigurationSceneComponentCamera : UDisplayClusterConfigurationSceneComponent
---@field InterpupillaryDistance float
---@field bSwapEyes boolean
---@field StereoOffset EDisplayClusterConfigurationEyeStereoOffset
local UDisplayClusterConfigurationSceneComponentCamera = {}



---@class UDisplayClusterConfigurationSceneComponentScreen : UDisplayClusterConfigurationSceneComponent
---@field Size FVector2D
local UDisplayClusterConfigurationSceneComponentScreen = {}



---@class UDisplayClusterConfigurationSceneComponentXform : UDisplayClusterConfigurationSceneComponent
local UDisplayClusterConfigurationSceneComponentXform = {}


---@class UDisplayClusterConfigurationViewport : UDisplayClusterConfigurationData_Base
---@field bAllowRendering boolean
---@field Camera FString
---@field ProjectionPolicy FDisplayClusterConfigurationProjection
---@field DisplayDeviceName FString
---@field bAllowPreviewFrustumRendering boolean
---@field Region FDisplayClusterConfigurationRectangle
---@field ViewportRemap FDisplayClusterConfigurationViewport_Remap
---@field OverlapOrder int32
---@field GPUIndex int32
---@field RenderSettings FDisplayClusterConfigurationViewport_RenderSettings
---@field ICVFX FDisplayClusterConfigurationViewport_ICVFX
local UDisplayClusterConfigurationViewport = {}



---@class UDisplayClusterMediaOutputSynchronizationPolicy : UObject
local UDisplayClusterMediaOutputSynchronizationPolicy = {}


